Attribute VB_Name = "Interface"
Option Explicit

'----------------------------------------------------------
'  Myriad
'  Interface Module
'----------------------------------------------------------
'  Version 1.3.1 (2005-02-05)
'  1.0.0: Module started, cleaning up and moving other
'         code. (Cloaked)
'  1.1.0: Moved from CSB to BnetBot class, accordingly,
'         added new BotEvent sub for BnetBot.
'  1.1.1: Added Navigate sub. (Cloaked)
'  1.2.0: Added web channel support. (Cloaked)
'  1.2.1: Channel list management redone. (Cloaked)
'  1.2.2: Added event log. (Cloaked)
'  1.3.0: Added function to retrieve system fonts. (Cloaked)
'----------------------------------------------------------

'----------------------------------------------------------
'  Color Codes
'----------------------------------------------------------
Public Const AtomicBlue = 15571536, vbSilver = &HC0C0C0, WhisperBlue = 12092001, _
    SelfTalkBlue = 16768256

'----------------------------------------------------------
'  Chat Icons
'----------------------------------------------------------
Public Const ICON_BLIZ& = 1
Public Const ICON_BNET& = 2
Public Const ICON_CHAT& = 3
Public Const ICON_D2DV& = 4
Public Const ICON_D2XP& = 5
Public Const ICON_DRTL& = 6
Public Const ICON_DSHR& = 7
Public Const ICON_JSTR& = 8
Public Const ICON_MEGA& = 9
Public Const ICON_OPER& = 10
Public Const ICON_UNKN& = 11
Public Const ICON_SEXP& = 12
Public Const ICON_SPWN& = 13
Public Const ICON_SQEL& = 14
Public Const ICON_SSHR& = 15
Public Const ICON_STAR& = 16
Public Const ICON_W2BN& = 17
Public Const ICON_W3XP& = 18
Public Const ICON_WAR3& = 19

Public Enum verType
    mvTitlebar
    mvAbout
End Enum

'----------------------------------------------------------
'  Interface Settings
'----------------------------------------------------------
Public useTimestamps As Boolean, use24HourTimestamps As Boolean, _
    showJoinLeave As Boolean, ticTacToeActive As Boolean, useBanFilter As Boolean
Private wasBanned As Boolean
Public clanWindowOpen As Boolean

'----------------------------------------------------------
'  Logging
'----------------------------------------------------------
Public Enum LoggingMode
    logAll
    logChat
    logCommands
    logNone
End Enum
Public toLog As LoggingMode
Public logEvents As Boolean, writeEventLog As Boolean, _
    logWindowSize As Long

'-----------------------------------------------------------------------------------
'  System Tray
'-----------------------------------------------------------------------------------
Public Enum NotifyTypes
    ntOther
    ntOldVersion
End Enum

Public autoMinimizeTray As Boolean
Public InTray As Boolean
Public notifyOnWhisper As Boolean, notifyOnError As Boolean, notifyOnOld As Boolean, _
    notifyOnAmigo As Boolean, notifyType As NotifyTypes

'----------------------------------------------------------
'  Web Channel
'----------------------------------------------------------
'Public WB As WebBot
'Public wbURL As String, wbEnabled As Boolean

'----------------------------------------------------------
'  News
'----------------------------------------------------------
Private NewsReq As WinHttpRequest
Public FetchingNews As Boolean

'----------------------------------------------------------
'  Main Window
'----------------------------------------------------------
Public lockWindow As Boolean

'----------------------------------------------------------
'  Fonts
'----------------------------------------------------------
Private Type LOGFONT
    lfHeight As Long
    lfWidth As Long
    lfEscapement As Long
    lfOrientation As Long
    lfWeight As Long
    lfItalic As Byte
    lfUnderline As Byte
    lfStrikeOut As Byte
    lfCharSet As Byte
    lfOutPrecision As Byte
    lfClipPrecision As Byte
    lfQuality As Byte
    lfPitchAndFamily As Byte
    lfFaceName(32) As Byte
End Type

Private Type ENUMLOGFONTEX
    elfLogFont As LOGFONT
    elfFullName As String * 64
    elfStyle As String * 64
    elfScript As String * 64
End Type

Private Type NEWTEXTMETRIC
    tmHeight As Long
    tmAscent As Long
    tmDescent As Long
    tmInternalLeading As Long
    tmExternalLeading As Long
    tmAveCharWidth As Long
    tmMaxCharWidth As Long
    tmWeight As Long
    tmOverhang As Long
    tmDigitizedAspectX As Long
    tmDigitizedAspectY As Long
    tmFirstChar As Byte
    tmLastChar As Byte
    tmDefaultChar As Byte
    tmBreakChar As Byte
    tmItalic As Byte
    tmUnderlined As Byte
    tmStruckOut As Byte
    tmPitchAndFamily As Byte
    tmCharSet As Byte
    'NEWTEXTMETRIC-specific
    ntmFlags As Long
    ntmSizeEM As Long
    ntmCellHeight As Long
    ntmAvgWidth As Long
End Type

Private Const DEFAULT_FARR_SIZE& = 64
Private FArr() As String, FArrSize As Long, FArrCapacity As Long

'Private Type NEWTEXTMETRICEX
'    ntmTm As NEWTEXTMETRICEX
'    ntmFontSig As FONTSIGNATURE
'End Type

' Device Contexts
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hDC As Long) As Long

' Enumeration
Private Declare Function EnumFontFamiliesEx Lib "gdi32" Alias "EnumFontFamiliesExA" _
    (ByVal hDC As Long, lpLogfond As LOGFONT, ByVal lpEnumFontFamExProc As Long, _
    lParam As Any, dwFlags As Long) As Long

'----------------------------------------------------------
'  Channel List
'----------------------------------------------------------
Private NextOp As Long

'----------------------------------------------------------
'  Web Browser
'----------------------------------------------------------
Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

'----------------------------------------------------------
'  Common Controls
'----------------------------------------------------------
Private Type tagInitCommonControlsEx
   lngSize As Long
   lngICC As Long
End Type
Private Declare Function InitCommonControlsEx Lib "comctl32.dll" _
   (iccex As tagInitCommonControlsEx) As Boolean
Private Const ICC_USEREX_CLASSES = &H200

'----------------------------------------------------------
'  Version String
'  Returns "Myriad " and then the current version.
'----------------------------------------------------------
Public Function GetVersion(Optional VT As verType = mvTitlebar) As String
    If VT = mvTitlebar Then
        GetVersion = "Myriad " & verMajor & "." & verMinor & "." & verRevision
    ElseIf VT = mvAbout Then
        GetVersion = "Version " & verMajor & "." & verMinor & "." & verRevision
    End If
    
    Select Case mRelease
        Case mrPrivAlpha: GetVersion = GetVersion & " Private Alpha"
        Case mrPrivBeta: GetVersion = GetVersion & " Private Beta"
        Case mrPubAlpha: GetVersion = GetVersion & " Alpha"
        Case mrPubBeta: GetVersion = GetVersion & " Beta"
        Case mrPrivate: GetVersion = GetVersion & " Private"
        Case mrDevelopment: GetVersion = GetVersion & " Development"
    End Select
    If (verModifier > 0) Then
        Select Case mRelease
            Case mrPrivAlpha, mrPrivBeta, mrPubAlpha, mrPubBeta
                GetVersion = GetVersion & Space$(1) & verModifier
            Case mrPrivate, mrDevelopment
                GetVersion = GetVersion & " R" & verModifier
        End Select
    End If
    
    If VT = mvAbout Then _
        GetVersion = GetVersion & " Build " & verBuild
End Function

'----------------------------------------------------------
'  Client Icon
'  Returns a code corresponding to an icon appropriate
'  for the client and flags in the icons ImageList.
'  [DEPRECATED] For compatibility with legacy CSB elements.
'----------------------------------------------------------
Public Function GetClientIcon(Client As String, Flags As Long) As Long
    'By Cloaked 5/19/2004
    GetClientIcon = IconCode(ClientStrToKey(Client), Flags)
End Function

'----------------------------------------------------------
'  QuickChannel List Builder
'  Populates the "Quick Channel" menu.
'----------------------------------------------------------
Public Function BuildQuickChannel() As Boolean
    Open (App.Path & "\quickchannels.txt") For Input As #1
    Dim z As String, i&
    On Error Resume Next
    For i = 0 To 8
        If EOF(1) Then
            frmMain.mnuQC(i).Visible = False
        Else
            Input #1, z
            z = Trim$(z)
            With frmMain.mnuQC(i)
                If LenB(z) Then
                    .Visible = True
                    .Caption = z
                Else
                    .Visible = False
                End If
            End With
        End If
    Next i
    Close #1
    'Dim F As New File
    'If (F.Load(App.Path & "\quickchannels.txt", fileRead)) Then
    '    Dim R$, i&
    '    For i = 0 To 8
    '        R = F.ReadLine()
    '        If Len(R) Then
    '            With frmMain.mnuQC(i)
    '                .Visible = True
    '                .Caption = R
    '            End With
    '        Else
    '            Exit For
    '        End If
    '    Next i
    '    BuildQuickChannel = True
    '    If F.Unload() = False Then
    '        MsgBox "Error closing file handle: " & F.GetErrorMessage(), _
    '            vbExclamation, GetVersion()
    '    End If
    'Else
    '    MsgBox "Error loading quick channel list: " & F.GetErrorMessage(), _
    '        vbExclamation, GetVersion()
    '    BuildQuickChannel = False
    'End If
End Function

'----------------------------------------------------------
'  Logger
'  Writes log messages to a log file.
'----------------------------------------------------------
Public Sub Logger(ByVal LogString$, Optional ByVal LogFile$)
On Error GoTo Log_Error
    If LenB(LogString) = 0 Then Exit Sub
    If LenB(LogFile) Then
        Open App.Path & "\logs\" & LogFile For Append As #4
    Else
        Open App.Path & "\logs\" & Year(Date) & "-" & Month(Date) & _
            "-" & Day(Date) & ".log" For Append As #4
    End If
    'timestamps will always be used
    If use24HourTimestamps Then
        LogString = "[" & Format(Time, "hh:mm:ss") & "] " & LogString
    Else
        LogString = "[" & Format(Time, "h:mm:ss AM/PM") & "] " & LogString
    End If
    Print #4, LogString
    Close #4
Log_Error:
End Sub

'----------------------------------------------------------
'  Navigate
'  Sends the user to the specified URL.
'----------------------------------------------------------
Public Sub Navigate(ByVal URL As String)
    Dim APIReturnCode As Long
    APIReturnCode = ShellExecute(0, "open", URL, "", App.Path, 0)
    If APIReturnCode = 32 Then
        MsgBox "Could not find a file association for " & URL & " on your system. You should check that your browser is correctly installed and associated with this type of file.", vbExclamation, "Browser Unavailable"
    End If
End Sub

'----------------------------------------------------------
'  BotEvent Handler
'  Recieves notices from the Myriad BnetBot class.
'----------------------------------------------------------
Public Sub BotEvent(Key As String, evType As bnEvent, Optional ByVal Text As String = "", _
    Optional ByVal mUser As String = "", Optional ByVal Flags As Long = 0, _
    Optional ByVal Ping As Long = 0, Optional ByVal Extra As String = "")
    Dim lngWork&, dAccess&, dFlags&
    'Event Type
    mUser = ExtractUsername(mUser)
    Select Case evType
        Case evAbort
            AddC Text, vbRed
            LogEvent "Battle.Net connection aborted: " & Text, etError
        Case evBnlsConnect
            AddC "Connected to BNLS.", vbGreen
            If toLog = logAll Then Logger "Connected to BNLS."
        Case evBnlsConnecting
            AddC "Connecting to BNLS...", vbYellow
            If toLog = logAll Then Logger "Connecting to BNLS..."
        Case evBnlsDisconnect
            'Ignored.
        Case evBot
            '?
        Case evBroadcast
            AddC "Broadcast: " & Text, vbYellow
            'If wbEnabled Then WB.BNBroadcast Text
        Case evChannel
            'Never used, see evJoinedChannel.
        Case evConError
            AddC Text, vbRed
            LogEvent Text, etError
            If toLog = logAll Then Logger "Connection Error: " & Text
            frmMain.AnalyzeConfig
            isConnected = False
            frmMain.tmrNull.Enabled = False
        Case evConMsg
            AddC Text, vbYellow
            If toLog = logAll Then Logger Text
        Case evConnect
            LogEvent "Connected to Battle.Net", etSuccess
            AddC "Connected to Battle.Net.", vbGreen
            If toLog = logAll Then Logger "Connected to Battle.Net."
        Case evConnecting
            AddC "Connecting to Battle.Net...", vbYellow
            If toLog = logAll Then Logger "Connecting to Battle.Net..."
            isConnected = True
        Case evDbg
            If mRelease = mrDevelopment Then
                AddC "[Debug] " & Text, vbWhite
                If toLog = logAll Then Logger "[Debug] " & Text
            End If
        Case evDisconnect
            LogEvent "Battle.Net connection closed."
            AddC "Disconnected from Battle.Net.", vbRed
            StopIdling
            qStop
            StopEventQueue
            UpdateLocation Key, "", -1
            If toLog = logAll Then Logger "Disconnected from Battle.Net."
            frmMain.AnalyzeConfig
            isConnected = False
            frmMain.tmrNull.Enabled = False
        Case evEmote
            'why not? :D
            'If (ProcessCommand(Text, mUser) And toLog = logCommands) Then _
                Logger "<" & mUser & " " & Text & ">"
            'If wbEnabled Then WB.UserEmote mUser, Text, Flags
            If Left$(Text, 5) = "{\rtf" Then Exit Sub
            AddEvent ceEmote, mUser, Text, , Flags, Ping
        Case evError
            AddC Text, vbRed
            If toLog = logAll Or toLog = logChat Then _
                Logger "Battle.Net Error: " & Text
            'If wbEnabled Then WB.BNError Text
        Case evGeneratedMessage
            qAdd Text
        Case evGetOps
            If mUser = Bot.RealUsername Then
                AddC "You have received ops.", vbWhite
                SweepChannel
                TagbanSweep
                If toLog = logAll Or toLog = logChat Then _
                    Logger "You have received ops."
                'If wbEnabled Then WB.BNInfo "You have received ops."
                LogEvent "You have received ops."
            Else
                AddC mUser & " has received ops.", vbWhite
                If toLog = logAll Or toLog = logChat Then _
                    Logger mUser & " has received ops."
                'If wbEnabled Then WB.BNInfo mUser & " has received ops."
                LogEvent mUser & " has received ops."
            End If
        Case evHandshakeComplete
            LogEvent "Battle.Net handshake completed successfully.", etSuccess
            StartEventQueue
            frmMain.AnalyzeConfig
            isConnecting = False
            frmMain.tmrNull.Enabled = True
        Case evInfo
            lngWork = InStr(Text, " was banned")
            If lngWork > 0 Then
                If IsSafelisted(Mid$(Text, 1, (lngWork - 1))) Then _
                    Bot.Say "/unban " & Mid$(Text, 1, (lngWork - 1)) & " Safelisted"
                If Not useBanFilter Then _
                    AddC Text, vbYellow
            Else
                AddC Text, vbYellow
            End If
            If joinOnKick Then
                If ((Bot.Client = bpDiablo2x Or _
                    Bot.Client = bpDiablo2) And _
                    Left$(Text, Len(Bot.RealUsername) + 12) _
                    = "*" & Bot.RealUsername & " was banned") _
                    Or ((Bot.Client <> bpDiablo2 Or _
                    Bot.Client <> bpDiablo2x) And _
                    Left$(Text, Len(Bot.RealUsername) + 11) _
                    = Bot.RealUsername & " was banned") Then
                    
                    wasBanned = True
                ElseIf InStr(Text, "kicked you") Then
                    If Not wasBanned Then
                        If rejoinOnKick Then
                            qAdd "/join " & Bot.Channel
                        Else
                            qAdd "/join " & kickTarget
                        End If
                    Else
                        wasBanned = False
                    End If
                End If
            End If
                    
            If toLog = logAll Or toLog = logChat Then _
                Logger "Battle.Net Info: " & Text
            'If wbEnabled Then WB.BNInfo Text
        Case evJoin
            AddEvent ceJoin, mUser, , ClientStrToKey(Text), Flags, Ping
        Case evJoinedChannel
            If Flags > 0 Then
                AddC "Joined " & ChannelFlagsToStr(Flags) & " channel " & Text & ".", vbYellow
                If toLog = logAll Or toLog = logChat Then _
                    Logger "Joined " & ChannelFlagsToStr(Flags) & " channel " & Text & "."
            Else
                AddC "Joined normal channel " & Text & ".", vbYellow
                If toLog = logAll Or toLog = logChat Then _
                    Logger "Joined normal channel " & Text & "."
            End If
            ClearChannelUsers frmMain.lvUsers
            'If wbEnabled Then WB.JoinChannel Text
        Case evPart
            'If wbEnabled Then WB.UserLeave mUser
            AddEvent ceLeave, mUser
        Case evProxyConnect
            AddC "Connected to proxy.", vbWhite
            If toLog = logAll Then Logger "Connected to proxy."
        Case evProxyConnecting
            AddC "Connecting to proxy...", vbWhite
            If toLog = logAll Then Logger "Connecting to proxy..."
        Case evRegisterEmail
            frmEmail.Show
        Case evSelfTalk
            If Left$(Text, 1) <> "/" Then _
                AddC_SCColors "<" & Bot.RealUsername & "> ", SelfTalkBlue, Text, vbWhite
            If toLog = logAll Or toLog = logChat Then _
                Logger "<" & Bot.RealUsername & "> " & Text
            'If wbEnabled Then WB.BotSays Bot.RealUsername, Text
        Case evSuccess
            AddC Text, vbGreen
            If toLog = logAll Then Logger Text
        Case evTalk
            If Left$(Text, 5) = "{\rtf" Then Exit Sub
            If Not (Meeting Is Nothing) Then
                If (Not Meeting.CanSpeak(mUser)) Then
                    qAdd "/kick " & FixUsername(mUser) & " Silence", 1
                End If
            End If
            If (ProcessCommand(Text, mUser) And toLog = logCommands) Then _
                Logger "<" & mUser & "> " & Text
            'If wbEnabled Then WB.UserSays mUser, Text, Flags
            AddEvent ceSay, mUser, Text
        Case evUser
            AddChannelUser frmMain.lvUsers, mUser, ClientStrToKey(Text), Flags, Ping
            If toLog = logAll Or toLog = logChat Then
                Logger mUser & " is in the channel using " & _
                    ClientKeyToName(ClientStrToKey(Text)) & "."
            End If
            'If wbEnabled Then WB.UserPresent mUser, Text, Flags, Ping
        Case evUserFlags
            If (Bot.HasOps And useIPBans And (Flags And USER_SQUELCHED) = USER_SQUELCHED) And (Flags And USER_CHANNELOP) <> USER_CHANNELOP And (Flags And USER_BLIZZREP) <> USER_BLIZZREP And (Flags And USER_ADMIN) <> USER_ADMIN Then
                If Not IsSafelisted(mUser) Then _
                    qAdd "/ban " & D2Username(mUser) & " IP-banned"
            End If
            
            AddEvent ceUserFlags, mUser, , ClientStrToKey(Text), Flags, Ping
            'If wbEnabled Then WB.UserFlags mUser, Flags
        Case evWhisperRecv
            If Left$(Text, 5) = "{\rtf" Then Exit Sub
            If Left$(Text, 7) = "MY-IB" Then
                ProcessInterbot Text, mUser
                Exit Sub
            End If
            If (ProcessCommand(Text, mUser, 1) And toLog = logCommands) Then _
                Logger "<From: " & mUser & "> " & Text
            AddEvent ceWhisperRecv, mUser, Text, , Flags, Ping
        Case evWhisperSend
            If Left$(Text, 7) = "MY-IB" Then
                Exit Sub
            End If
            
            If toLog = logAll Or toLog = logChat Then _
                Logger "<To: " & mUser & "> " & Text
            HandleWhisperSent mUser, Text
        Case evWrongPassword
            frmPassword.Show
    End Select
End Sub

Public Sub HandleJoin(mUser As String, Client As bnProduct, Flags As Long, Ping As Long, _
Optional ByVal NoMessage As Boolean = False)
On Error GoTo HNU_Error
    Dim dAccess&, dFlags&
    If Bot.HasOps Then
        GetUser mUser, dAccess, dFlags
        If (useIPBans And (Flags And USER_SQUELCHED) = USER_SQUELCHED And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST) Then
            qAdd "/ban " & D2Username(mUser) & " IP-banned"
        ElseIf (usePlugBans And (Flags And USER_NOUDP) = USER_NOUDP And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST And dAccess < 30) Then
            qAdd "/ban " & D2Username(mUser) & " Plug-ban"
        ElseIf (dFlags And ACCESS_SHITLIST) = ACCESS_SHITLIST And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST Then
            qAdd "/ban " & D2Username(mUser) & " Shitlisted"
        ElseIf (useLockdown And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST And dAccess < 30) Then
            qAdd "/ban " & D2Username(mUser) & Space$(1) & lockdownMessage
        ElseIf (useClientBans And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST And dAccess < 30 And IsClientbannedKey(Client)) Then
            qAdd "/ban " & D2Username(mUser) & " Client-ban"
        ElseIf (dFlags And ACCESS_MASTER) <> ACCESS_MASTER And (dFlags And ACCESS_SAFELIST) <> ACCESS_SAFELIST And dAccess < 30 Then
            If Not TagbanCheck(mUser) And useGreets Then _
                SendGreeting D2Username(mUser), Ping
        Else
            If useGreets Then _
                SendGreeting D2Username(mUser), Ping
        End If
    ElseIf useGreets Then
        SendGreeting D2Username(mUser), Ping
    End If
    If Not NoMessage Then
        If showJoinLeave Then _
            AddC mUser & " has joined the channel using " & _
            ClientKeyToName(Client) & ".", vbGreen
        If toLog = logAll Or toLog = logChat Then
            Logger mUser & " has joined the channel using " & _
                ClientKeyToName(Client) & "."
        End If
    End If
    AddChannelUser frmMain.lvUsers, mUser, Client, Flags, Ping
    If Not (AutoClan Is Nothing) Then
        AutoClan.UserEntered mUser
    End If
    ' Add user to the webbot Que
    'webicon = LCase(Client)
    'webuser = mUser
    'AddWebbot
    
    'If wbEnabled Then WB.UserJoin mUser, Text, Flags, Ping
    Exit Sub
HNU_Error:
    AddC "Error handling user join: " & Err.Description & " (#" & Err.Number & ").  " & _
        "Please report this bug.", vbRed
End Sub

Private Sub ProcessInterbot(Text As String, Username As String)
On Error GoTo PI_Error
    Dim Words() As String
    Words = Split(Text, " ")
    If UBound(Words) < 1 Then Exit Sub
    Select Case Words(1)
        Case "TIC-TAC-TOE"
            If UBound(Words) < 2 Then Exit Sub
            Select Case Words(2)
                Case "INIT"
                    If ticTacToeActive Then
                        qAdd "/w " & Username & " MY-IB " & Words(1) & " FAIL"
                        Exit Sub
                    End If
                    ticTacToeActive = True
                    Load frmTicTacToe
                    frmTicTacToe.TTT_Init Username
                Case "ACCEPT"
                    If Not ticTacToeActive Then Exit Sub
                    frmTicTacToe.TTT_Accept Username
                Case "END"
                    If Not ticTacToeActive Then Exit Sub
                    frmTicTacToe.TTT_Ended
                Case "MOVE"
                    If Not ticTacToeActive Then Exit Sub
                    If UBound(Words) < 4 Then Exit Sub
                    frmTicTacToe.TTT_Move Username, CLng(Val(Words(3))), _
                        CLng(Val(Words(4)))
                Case "FAIL"
                    If Not ticTacToeActive Then Exit Sub
                    frmTicTacToe.TTT_Rejected Username
            End Select
        Case Else
            qAdd "/w " & Username & " MY-IB " & Words(1) & " FAIL"
    End Select
PI_Error:
End Sub

Public Sub SendGreeting(ByVal Username$, ByVal Ping&)
    Dim gMsg$
    gMsg = greetMessage
    Username = ExtractD2Username(Username)
    If InStr(gMsg, "%") Then
        gMsg = Replace(gMsg, "%ver", GetVersion())
        gMsg = Replace(gMsg, "%name", Username)
        gMsg = Replace(gMsg, "%ping", Ping)
        gMsg = Replace(gMsg, "%uptime", ConvertTimeCondensed(GetTickCount()))
        gMsg = Replace(gMsg, "%buptime", ConvertTimeCondensed(GetTickCount() - startupTime))
        gMsg = Replace(gMsg, "%channel", Bot.Channel)
        gMsg = Replace(gMsg, "%mp3", GetSong())
    End If
    If whisperGreets Then
        If Bot.Client = bpDiablo2 Or Bot.Client = bpDiablo2x Then
            qAdd "/w *" & Username & Space$(1) & gMsg
        Else
            qAdd "/w " & Username & Space$(1) & gMsg
        End If
    Else
        qAdd gMsg
    End If
End Sub

Private Function ExtractD2Username(ByVal cUsername$) As String
    Dim Frag() As String
    If Left$(cUsername, 1) = "*" Then
        ExtractD2Username = Mid$(cUsername, 2)
    Else
        Frag = Split(cUsername, "*")
        If UBound(Frag) = 0 Then
            ExtractD2Username = Frag(0)
        Else
            ExtractD2Username = Frag(1)
        End If
    End If
End Function

Public Sub RequestProfile(Username As String)
    Dim Keys(3) As String
    Keys(0) = "Profile\Age"
    Keys(1) = "Profile\Sex"
    Keys(2) = "Profile\Location"
    Keys(3) = "Profile\Description"
    Bot.RequestProfile Username, Keys
End Sub

Public Sub ProfileReceived(bKey As String, Username As String, Keys() As String, _
    Values() As String)
    Dim P As frmProfile, i&
    Set P = New frmProfile
    
    With P
        For i = 0 To UBound(Keys)
            Select Case Keys(i)
                Case "Profile\Age": .setAge Values(i)
                Case "Profile\Sex": .setSex Values(i)
                Case "Profile\Location": .setLocation Values(i)
                Case "Profile\Description": .setDescription Values(i)
            End Select
        Next i
        
        .setUser Username
        .setBotKey bKey
        If Bot.Username = Username Then
            .setEditable True
        Else
            .setEditable False
        End If
        .DlgDraw
    End With

End Sub

Public Sub InvitedToClan(ByVal Key$, ByVal Cookie&, ByVal ClanTagRaw As Long, _
ByVal ClanTag$, ByVal ClanName$, ByVal InvitingUser$)
    Dim F As frmInvitation
    Set F = New frmInvitation
    F.DlgDraw Cookie, ClanTagRaw, ClanTag, ClanName, InvitingUser
End Sub

'Public Function FetchNews() As Boolean
'    Set NewsReq = New WinHttpRequest
'    With NewsReq
'        .Open "GET", "http://bnetweb.net/myriad/news.txt"
'        '.Open "GET", "http://bnetweb.net/myriad/check/" & verBuild & ".txt", True
'        .Send
'    End With
'    FetchingNews = True
'    FetchNews = True
'End Function

'Public Function HasNewsArrived() As Boolean
'On Error GoTo HNA_Error
'    HasNewsArrived = False
'    If NewsReq.Status > 0 Then
'        HasNewsArrived = True
'    End If
'    Exit Function
'HNA_Error:
'    HasNewsArrived = False
'End Function

'Public Function NewsAvailable() As Boolean
'On Error GoTo NA_Error
'    NewsAvailable = False
'    If NewsReq.Status = 200 Then NewsAvailable = True
'    Exit Function
'NA_Error:
'    NewsAvailable = False
'End Function

'Public Function GetNews() As String
'On Error GoTo GN_Error
'    Dim Tries&
'    GetNews = NewsReq.ResponseText
'    Exit Function
'GN_Error:
'    If Tries > 4 Then Exit Function
'    DoEvents
'    Tries = Tries + 1
'    Resume
'End Function

'Public Sub ReadNews()
'    Dim News$, Frag() As String, Words() As String, Status As String, Latest As String
'    News = GetNews
'    NewsCleanup
'    Frag = Split(News, vbCrLf)
'    Words = Split(Frag(0), " ")
'    Status = Words(0)
'
'    If Words(0) = verMajor & "." & verMinor & "." & verRevision Then
'        AddC "Your Myriad version is up to date.", vbGreen
'        AddC "Current Version: " & Status, vbGreen
'    Else
'        AddC "You are using an outdated version of Myriad, please obtain the latest version as soon as possible", vbRed
'        AddC "Download Latest version from: http://www.bnetweb.net", vbSilver
'        AddC "Your version: " & verMajor & "." & verMinor & "." & verRevision, vbRed
'        AddC "Latest version: " & Status, vbGreen
'    End If
    
'    Select Case Status
'        Case "OK"
'            ' Release is up to date.
'        Case "OLD"
'            Latest = Mid$(Frag(0), 5)
'            If InTray Then
'                notifyType = ntOldVersion
'                ShowNotification "Update Available", "You are using an old version of Myriad.  The latest version is " & Latest & ".  Click here to upgrade.", niWarning
'            End If
'
'            AddC "You are using an old version of Myriad.  The latest version is " & Latest & ".  You can upgrade by visting http://myriad.ionws.com/.", vbRed
'        Case "UNKNOWN"
'            AddC "You are using an unrecognized version of Myriad, probably a development version.", vbYellow
'        Case "ERROR"
'            AddC "There was an error while determining the status of your Myriad version.  Please report this bug.", vbRed
'        Case "DISABLED"
'            allowConnect = False
'            If (isConnected Or Bot.TalkOK) Then _
'                DisconnectBot
'            If InTray Then
'                notifyType = ntOther
'                ShowNotification "Version Disabled", "This version of Myriad has been disabled, probably due to a security hazard.  You must upgrade.", niError
'            End If
'            AddC "--- Error ---", vbRed
'            AddC "This version of Myriad has been disabled, probably due to a security vulnerability.  You must upgrade in order to continue using the bot.", vbRed
'            AddC "You can visit http://myriad.ionws.com/ to upgrade.", vbRed
'            AddC "--- Error ---", vbRed
'        Case Else
'            AddC "Unknown Myriad version status code """ & Status & """.  Please report this bug."
'    End Select
'    If UBound(Frag) > 0 Then _
'        DisplayNewsBody Frag
'End Sub

'Private Sub DisplayNewsBody(Lines() As String)
'    Dim i&
'    For i = 1 To UBound(Lines)
'        If (LenB(Lines(i)) > 0) Then _
'            AddC "Myriad News: " & Lines(1), vbYellow
'    Next i
'End Sub

Public Sub NewsCleanup()
    Set NewsReq = Nothing
End Sub

Public Function ClientStrToKey(strClient As String) As bnProduct
    Select Case strClient
        Case "STAR": ClientStrToKey = bpStarCraft
        Case "SEXP": ClientStrToKey = bpBroodWar
        Case "D2DV": ClientStrToKey = bpDiablo2
        Case "D2XP": ClientStrToKey = bpDiablo2x
        Case "W2BN": ClientStrToKey = bpWarCraft2
        Case "WAR2": ClientStrToKey = bpWarCraft2 'for stupid people
        Case "WAR3": ClientStrToKey = bpWarCraft3
        Case "W3XP": ClientStrToKey = bpWarCraft3x
        Case "JSTR": ClientStrToKey = bpStarCraftJapan
        'Myriad does not support any clients below here.
        Case "SSHR": ClientStrToKey = bpStarCraftSW
        Case "DRTL": ClientStrToKey = bpDiablo
        Case "DSHR": ClientStrToKey = bpDiabloSW
        'Case "BLIZ": ClientStrToKey = bpBlizzard
        'Case "BNET": ClientStrToKey = bpBnetRep
        Case Else: ClientStrToKey = bpUnknown
    End Select
End Function

Public Function ClientKeyToStr(Client As bnProduct) As String
    Select Case Client
        Case bpStarCraft: ClientKeyToStr = "STAR"
        Case bpBroodWar: ClientKeyToStr = "SEXP"
        Case bpDiablo2: ClientKeyToStr = "D2DV"
        Case bpDiablo2x: ClientKeyToStr = "D2XP"
        Case bpWarCraft2: ClientKeyToStr = "W2BN"
        Case bpWarCraft3: ClientKeyToStr = "WAR3"
        Case bpWarCraft3x: ClientKeyToStr = "W3XP"
    End Select
End Function

Public Function ClientKeyToIcon(Key As bnProduct) As Long
    Select Case Key
        Case bpBlizzard: ClientKeyToIcon = ICON_BLIZ
        Case bpBnetRep: ClientKeyToIcon = ICON_BNET
        Case bpBroodWar: ClientKeyToIcon = ICON_SEXP
        Case bpChat: ClientKeyToIcon = ICON_CHAT
        Case bpDiablo: ClientKeyToIcon = ICON_DRTL
        Case bpDiabloSW: ClientKeyToIcon = ICON_DSHR
        Case bpDiablo2: ClientKeyToIcon = ICON_D2DV
        Case bpDiablo2x: ClientKeyToIcon = ICON_D2XP
        Case bpStarCraft: ClientKeyToIcon = ICON_STAR
        Case bpStarCraftJapan: ClientKeyToIcon = ICON_JSTR
        Case bpStarCraftSW: ClientKeyToIcon = ICON_SSHR
        Case bpWarCraft2: ClientKeyToIcon = ICON_W2BN
        Case bpWarCraft3: ClientKeyToIcon = ICON_WAR3
        Case bpWarCraft3x: ClientKeyToIcon = ICON_W3XP
        Case Else: ClientKeyToIcon = ICON_UNKN
    End Select
End Function

Public Function ClientKeyToName(Key As bnProduct) As String
    Select Case Key
        Case bpBlizzard: ClientKeyToName = "a Blizzard Rep. client"
        Case bpBnetRep: ClientKeyToName = "a Battle.Net admin client"
        Case bpBroodWar: ClientKeyToName = "Brood War"
        Case bpChat: ClientKeyToName = "a chat client"
        Case bpDiablo: ClientKeyToName = "Diablo"
        Case bpDiabloSW: ClientKeyToName = "Diablo Shareware"
        Case bpDiablo2: ClientKeyToName = "Diablo II"
        Case bpDiablo2x: ClientKeyToName = "Diablo II: Lord of Descruction"
        Case bpStarCraft: ClientKeyToName = "StarCraft"
        Case bpStarCraftJapan: ClientKeyToName = "StarCraft Japan"
        Case bpStarCraftSW: ClientKeyToName = "StarCraft Shareware"
        Case bpWarCraft2: ClientKeyToName = "WarCraft II BNE"
        Case bpWarCraft3: ClientKeyToName = "WarCraft III"
        Case bpWarCraft3x: ClientKeyToName = "WarCraft III: The Frozen Throne"
        Case Else: ClientKeyToName = "an unknown client"
    End Select
End Function

'Used in frmSetup
Public Function ClientNameToKey(Name As String) As bnProduct
    Select Case Name
        Case "Brood War": ClientNameToKey = bpBroodWar
        Case "Diablo II": ClientNameToKey = bpDiablo2
        Case "Diablo II: Lord of Descruction": ClientNameToKey = bpDiablo2x
        Case "StarCraft": ClientNameToKey = bpStarCraft
        Case "WarCraft II BNE": ClientNameToKey = bpWarCraft2
        Case "WarCraft III": ClientNameToKey = bpWarCraft3
        Case "WarCraft III: The Frozen Throne": ClientNameToKey = bpWarCraft3x
        Case Else: ClientNameToKey = bpUnknown
    End Select
End Function

Public Function ChannelFlagsToStr(Flags As Long) As String
    'Select Case Flags
    '    Case CHANNEL_GLOBAL: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    '    Case CHANNEL_: ChannelFlagsToStr = ""
    'End Select
    'Dim strT As String * 4
    'CopyMemory strT, ByVal Flags, 4
    If (Flags And CHANNEL_GLOBAL) = CHANNEL_GLOBAL Then
        ChannelFlagsToStr = "global"
    ElseIf (Flags And CHANNEL_MODERATED) = CHANNEL_MODERATED Then
        ChannelFlagsToStr = "moderated"
    ElseIf (Flags And CHANNEL_PUBLIC) Then
        ChannelFlagsToStr = "public"
    ElseIf (Flags And CHANNEL_RESTRICTED) Then
        ChannelFlagsToStr = "restricted"
    ElseIf (Flags And CHANNEL_PRODUCTSPECIFIC) Then
        ChannelFlagsToStr = "product-specific"
    ElseIf (Flags And CHANNEL_SILENT) Then
        ChannelFlagsToStr = "silent"
    ElseIf (Flags And CHANNEL_SYSTEM) Then
        ChannelFlagsToStr = "system"
    Else
        ChannelFlagsToStr = "unknown"
    End If
End Function

Public Function IconCode(Product As bnProduct, Flags As Long) As Long
    IconCode = ClientKeyToIcon(Product)
    If (Flags And USER_SQUELCHED) Then IconCode = ICON_SQEL
    If (Flags And USER_CHANNELOP) Then IconCode = ICON_OPER
    If (Flags And USER_SPEAKER) Then IconCode = ICON_MEGA
    If (Flags And USER_ADMIN) Then IconCode = ICON_BNET
    If (Flags And USER_BLIZZREP) Then IconCode = ICON_BLIZ
End Function

Public Sub AddChannelUser(L As ListView, Username As String, Client As bnProduct, _
    Flags As Long, Ping As Long)
    ' Add user to webbot's que
    'webicon = LCase(Client)
    'webusername = Username
    'AddWebbot
    'AddC "Adding channel user " & Username
On Error GoTo ACU_Error
    'AddC "ACU: " & NextOp
    If Flags And USER_CHANNELOP Then
        
        NextOp = NextOp + 1
        With L.ListItems.Add(1, "cu_" & Username, Username, , _
            IconCode(Client, Flags))
            .ForeColor = vbWhite
            .SubItems(1) = Ping
            With .ListSubItems(1)
                Select Case Ping
                    Case -1
                        .ForeColor = vbRed
                    Case Is < 10
                        .ForeColor = SelfTalkBlue
                    Case Is < 300
                        .ForeColor = vbGreen
                    Case Is < 500
                        .ForeColor = vbYellow
                    Case Is >= 500
                        .ForeColor = vbRed
                    Case Else
                        .ForeColor = vbRed
                End Select
            End With
            '.ToolTipText = Username
            .Tag = Username
        End With
        
    Else
        With L.ListItems.Add(, "cu_" & Username, Username, , _
            IconCode(Client, Flags))
            .ForeColor = vbYellow
            .SubItems(1) = Ping
            With .ListSubItems(1)
                Select Case Ping
                    Case -1
                        .ForeColor = vbRed
                    Case Is < 10
                        .ForeColor = SelfTalkBlue
                    Case Is < 300
                        .ForeColor = vbGreen
                    Case Is < 500
                        .ForeColor = vbYellow
                    Case Is >= 500
                        .ForeColor = vbRed
                    Case Else
                        .ForeColor = vbRed
                End Select
            End With
            '.ToolTipText = Username
            .Tag = Username
        End With
    End If
    L.Refresh
    Exit Sub
ACU_Error:
    'AddC "AddChannelUser: " & Err.Description & "(#" & Err.Number & ")", vbRed
End Sub

'Returns True if the user was found and removed; False if otherwise.
Public Function RemoveChannelUser(L As ListView, Username As String) As Boolean
On Error GoTo RCU_Error
    RemoveChannelUser = False
    L.ListItems.Remove "cu_" & Username
    L.Refresh
    RemoveChannelUser = True
Exit Function
RCU_Error:
    'AddC "RemoveChannelUser: " & Err.Description & "(#" & Err.Number & ")", vbRed
End Function

Public Sub UpdateChannelUser(L As ListView, Username As String, _
    Client As bnProduct, Flags As Long, Ping As Long)
    'AddC "Updating channel user " & Username
On Error GoTo UCU_Error
    'AddC "UCU: " & NextOp
    Dim i&
    If Flags And USER_CHANNELOP Then
        'With L.ListItems("cu_" & Username)
        RemoveChannelUser L, Username
        AddChannelUser L, Username, Client, Flags, Ping
    Else
        L.ListItems("cu_" & Username).SmallIcon = _
            IconCode(Client, Flags)
    End If
    L.Refresh
Exit Sub
UCU_Error:
    'AddC "UpdateChannelUser: " & Err.Description & "(#" & Err.Number & ")", vbRed
End Sub

Public Sub ClearChannelUsers(L As ListView)
    NextOp = 0
    L.ListItems.Clear
End Sub

Public Sub Remove()

End Sub

'Public Sub AddChannelUser(L As ListView, Username As String, _
'    Client As String, Flags As Long, Ping As Long)
'
'    If Flags And USER_CHANNELOP Then
'        With L.ListItems.Add(1, "cu_" & Username, Username, _
'            , GetClientIcon(Client, Flags))
'
'            .ForeColor = vbWhite
'            .SubItems(1) = Ping & "ms"
'            .Tag = Username
'        End With
'    Else
'        With L.ListItems.Add(, "cu_" & Username, Username, _
'            , GetClientIcon(Client, Flags))
'
'            .ForeColor = vbYellow
'            .SubItems(1) = Ping & "ms"
'            .Tag = Username
'        End With
'    End If
'End Sub

'Public Sub AddChannelUser(L As ListView, Username As String, _
    Client As String, Flags As Long, Ping As Long)
'On Error Resume Next
'    Dim i&
'    If Flags And USER_CHANNELOP Then
'        'trigger list rebuild
'        Bot.BuildChannelList L
'    Else
'        i = L.ListItems.Count + 1
'        L.ListItems.Add i, "cu_" & Username, Username, , GetClientIcon(Client, Flags)
'        L.ListItems(i).ForeColor = vbYellow
'        L.ListItems(i).SubItems(1) = Ping & "ms"
'        L.ListItems(i).Tag = Username
'    End If
'End Sub

'Public Sub RemoveChannelUser(L As ListView, Username As String)
'On Error Resume Next
'    L.ListItems.Remove "cu_" & Username
'End Sub

'Public Sub UpdateChannelUser(L As ListView, Username As String, _
'    Flags As Long)
'On Error Resume Next
'    L.ListItems("cu_ " & Username).SmallIcon = GetClientIcon("", Flags)
'End Sub

'Public Sub ClearChannelUsers(L As ListView)
'On Error Resume Next
'    L.ListItems.Clear
'End Sub

Public Sub UpdateLocation(BotKey As String, Channel As String, ByVal Users As Integer)
    If Users > -1 Then
        frmMain.lblChannel = Channel & " (" & Bot.UsersInChannel & ")"
        frmMain.Caption = GetVersion() & " - " & Bot.RealUsername & " in " & Channel
        SetToolTip GetVersion() & " - " & Bot.RealUsername & " in " & Channel
    Else
        frmMain.lblChannel = ""
        frmMain.Caption = GetVersion()
        SetToolTip GetVersion()
        ClearChannelUsers frmMain.lvUsers
    End If
End Sub

Private Function EnumFontProc(lpefe As ENUMLOGFONTEX, lpntme As NEWTEXTMETRIC, _
FontType As Long, lParam As Long) As Long
On Error GoTo EFP_Error
    Dim FaceName As String
    EnumFontProc = 1
    If (FArrSize >= FArrCapacity) Then
        ReDim Preserve FArr(FArrCapacity + DEFAULT_FARR_SIZE) As String
        FArrCapacity = FArrCapacity + DEFAULT_FARR_SIZE
    End If
    
    FaceName = StrConv(lpefe.elfLogFont.lfFaceName, vbFromUnicode)
    FArr(FArrSize) = Left$(FaceName, InStr(FaceName, vbNullChar) - 1)
    FArrSize = FArrSize + 1
    Exit Function
EFP_Error:
    Debug.Print Err.Description
    EnumFontProc = 0
End Function

Public Function GetFonts(ByVal hwnd As Long, Fonts() As String) As Long
    Dim DC&, LF As LOGFONT, i&
    DC = GetDC(hwnd)
    LF.lfCharSet = 1 'DEFAULT_CHARSET
    LF.lfFaceName(0) = 0
    LF.lfPitchAndFamily = 0
    
    FArrSize = 0
    FArrCapacity = DEFAULT_FARR_SIZE
    ReDim FArr(FArrCapacity) As String
    
    EnumFontFamiliesEx DC, LF, AddressOf EnumFontProc, 0, 0
    
    If FArrSize = 0 Then
        GetFonts = 0
        Exit Function
    End If
    
    ReDim Fonts(FArrSize - 1) As String
    For i = 0 To (FArrSize - 1)
        Fonts(i) = FArr(i)
    Next i
    GetFonts = FArrSize
    ReleaseDC hwnd, DC
End Function

Public Sub NotifyUserMove(Bot As String, Action As Long)
    'Do nothing.
End Sub

'----------------------------------------------------------
'  Text Adder
'  Adds text to the chat window.
'----------------------------------------------------------
Public Sub AddC(ParamArray saElements() As Variant)
    Dim i&, oS&, oL&
    If lockWindow Then Exit Sub
    
    oL = frmMain.rtbChannel.SelLength
    If oL > 0 Then _
        oS = frmMain.rtbChannel.SelStart
    
    If useTimestamps Then
        With frmMain.rtbChannel
            .SelStart = Len(.Text)
            .SelLength = 0
            .SelColor = vbWhite
            If use24HourTimestamps Then
                .SelText = "[" & Format(Time, "hh:mm:ss") & "] "
            Else
                .SelText = "[" & Format(Time, "h:mm:ss AM/PM") & "] "
            End If
            .SelStart = Len(.Text)
        End With
    End If
    For i = LBound(saElements) To UBound(saElements) Step 2
        With frmMain.rtbChannel
            .SelStart = Len(.Text)
            .SelLength = 0
            If (i + 1) <= UBound(saElements) Then
                .SelColor = saElements(i + 1)
            Else
                .SelColor = vbWhite
            End If
            .SelText = CStr(saElements(i))
            .SelStart = Len(.Text)
        End With
    Next i
    With frmMain.rtbChannel
        .SelStart = Len(.Text)
        .SelLength = 0
        .SelColor = vbWhite
        .SelText = vbCrLf
        If oL > 0 Then
            .SelStart = oS
            .SelLength = oL
        End If
    End With
End Sub

'----------------------------------------------------------
'  Text Adder With StarCraft Color Codes
'  Adds text to the chat window and processes StarCraft
'  color codes.
'----------------------------------------------------------
Public Sub AddC_SCColors(sText As String, sColor As Long, ByVal Message As String, _
    mColor As ColorConstants, Optional eText As String = "")
    '-----------------------------------------------------'
    ' From Myriad 1.0 Private Alpha                       '
    ' By Cloaked                                          '
    '-----------------------------------------------------'
    Dim i&, L&, CC As Long, ct As String, cChar As String, oS&, oL&
    
    If lockWindow Then Exit Sub
    
    oL = frmMain.rtbChannel.SelLength
    If oL > 0 Then _
        oS = frmMain.rtbChannel.SelStart
    
    'Do some initializing.
    i = 1
    L = Len(Message)
    ct = ""
    CC = mColor
    
    
    With frmMain.rtbChannel
        'Timestamp
        If useTimestamps Then
            .SelStart = Len(.Text)
            .SelLength = 0
            .SelColor = vbWhite
            If use24HourTimestamps Then
                .SelText = "[" & Format(Time, "hh:mm:ss") & "] "
            Else
                .SelText = "[" & Format(Time, "h:mm:ss AM/PM") & "] "
            End If
        End If

        'Starting text
        .SelStart = Len(.Text)
        .SelLength = 0
        .SelColor = sColor
        .SelText = sText
    End With
    
    'Main message loop
    While i <= L
        cChar = Mid$(Message, i, 1)
        If cChar = "" Then
            'Color detection
            With frmMain.rtbChannel
                .SelStart = Len(.Text)
                .SelLength = 0
                .SelColor = CC
                .SelText = ct
            End With
            ct = ""
            i = i + 1
            CC = SCColorToVBColor(Mid$(Message, i, 1), sColor)
        ElseIf Mid$(Message, i, 2) = "Á" Then
            'Crude support for the accented A represented in UTF-8 (?)
            With frmMain.rtbChannel
                .SelStart = Len(.Text)
                .SelLength = 0
                .SelColor = CC
                .SelText = ct
            End With
            ct = ""
            i = i + 2
            CC = SCColorToVBColor(Mid$(Message, i, 1), sColor)
        Else
            ct = ct & cChar
        End If
        i = i + 1
    Wend
    With frmMain.rtbChannel
        'Flush what's left in the message buffer
        .SelStart = Len(.Text)
        .SelLength = 0
        .SelColor = CC
        .SelText = ct
        'Add newline characters
        If Len(eText) = 0 Then
            eText = vbCrLf
        Else
            eText = eText & vbCrLf
        End If
        'Add ending text
        .SelStart = Len(.Text)
        .SelLength = 0
        .SelColor = sColor
        .SelText = eText
        If oL > 0 Then
            .SelStart = oS
            .SelLength = oL
        End If
    End With
End Sub

Public Function SCColorToVBColor(ColorCode As String, Optional ByVal Default& = vbWhite) As Long
    Select Case ColorCode
        Case "Y": SCColorToVBColor = vbRed
        Case "U", "T", "V": SCColorToVBColor = vbCyan
        Case "S", "X", "Z": SCColorToVBColor = vbYellow
        Case "R": SCColorToVBColor = vbGreen
        Case "P", "W": SCColorToVBColor = vbWhite
        Case "Q": SCColorToVBColor = &H808080
        Case Else: SCColorToVBColor = Default
    End Select
End Function

Public Function StrToHex(ByVal String1 As String) As String
On Error Resume Next
    Dim strTemp As String, strReturn As String, i As Long
    
    For i = 1 To Len(String1)
        strTemp = Hex(Asc(Mid(String1, i, 1)))
        If Len(strTemp) = 1 Then strTemp = "0" & strTemp
        If i = 1 Then
            strReturn = strTemp
        Else
            strReturn = strReturn & " " & strTemp
        End If
    Next i
    StrToHex = strReturn
End Function

Public Function ConvertTime(ByVal lngMS As Long) As String
    Dim lngSeconds As Long, lngDays As Long, lngHours As Long, lngMins As Long
    Dim strSeconds As String, strDays As String
    lngSeconds = lngMS / 1000
    lngDays = Int(lngSeconds / 86400)
    lngSeconds = lngSeconds Mod 86400
    lngHours = Int(lngSeconds / 3600)
    lngSeconds = lngSeconds Mod 3600
    lngMins = Int(lngSeconds / 60)
    lngSeconds = lngSeconds Mod 60
    If lngSeconds <> 1 Then strSeconds = "s"
    If lngDays <> 1 Then strDays = "s"
    ConvertTime = lngDays & " day" & strDays & ", " & lngHours & " hours, " & lngMins & " minutes and " & lngSeconds & " second" & strSeconds
End Function

Public Function ConvertTimeCondensed(ByVal lngMS As Long) As String
    Dim lngSeconds As Long, lngDays As Long, lngHours As Long, lngMins As Long
    lngSeconds = lngMS / 1000
    lngDays = Int(lngSeconds / 86400)
    lngSeconds = lngSeconds Mod 86400
    lngHours = Int(lngSeconds / 3600)
    lngSeconds = lngSeconds Mod 3600
    lngMins = Int(lngSeconds / 60)
    lngSeconds = lngSeconds Mod 60
    
    ConvertTimeCondensed = ""
    
    If lngDays = 1 Then
        ConvertTimeCondensed = lngDays & " day "
    ElseIf lngDays > 1 Then
        ConvertTimeCondensed = lngDays & " days "
    End If
    
    If lngHours < 10 Then _
        ConvertTimeCondensed = ConvertTimeCondensed & "0"
    ConvertTimeCondensed = ConvertTimeCondensed & lngHours & ":"
    
    If lngMins < 10 Then _
        ConvertTimeCondensed = ConvertTimeCondensed & "0"
    ConvertTimeCondensed = ConvertTimeCondensed & lngMins & ":"
    
    If lngSeconds < 10 Then _
        ConvertTimeCondensed = ConvertTimeCondensed & "0"
    ConvertTimeCondensed = ConvertTimeCondensed & lngSeconds
End Function

'----------------------------------------------------------
'  Common Controls
'----------------------------------------------------------
Public Function InitCommonControlsVB() As Boolean
   Dim iccex As tagInitCommonControlsEx
   ' Ensure common controls available:
   With iccex
       .lngSize = LenB(iccex)
       .lngICC = ICC_USEREX_CLASSES
   End With
   InitCommonControlsEx iccex
   InitCommonControlsVB = (Err.LastDllError = 0)
End Function

Public Sub ApplyFonts()
    'SetFont can recover better from invalid font sizes.
    SetFont frmMain.rtbChannel.Font, GetConfig("Channel", "Fonts"), GetConfig("ChannelSize", "Fonts")
    SetFont frmMain.rtbEvents.Font, GetConfig("Events", "Fonts"), GetConfig("EventsSize", "Fonts")
    SetFont frmMain.lvUsers.Font, GetConfig("List", "Fonts"), GetConfig("ListSize", "Fonts")
End Sub

Public Sub SetFont(F As IFontDisp, face As String, Size As String, _
Optional DefaultFace As String = "Tahoma", Optional DefaultSize As String = "8.25")
On Error GoTo SF_Error
    If LenB(face) = 0 Then
        F.Name = DefaultFace
    Else
        F.Name = face
    End If
    
    If LenB(Size) = 0 Then
        F.Size = DefaultSize
    Else
        F.Size = CCur(Val(Size))
    End If
    Exit Sub
SF_Error:
    If Err.Number = 380 Or Err.Number = 13 Then
        F.Size = CCur(Val(DefaultSize))
        Resume Next
    End If
End Sub

